import { Component, EventEmitter, HostBinding, Input, Output, ViewChild } from '@angular/core';
import { coerceBooleanProperty, coerceNumberProperty } from '@angular/cdk/coercion';
import merge from 'lodash-es/merge';
import { Chart, registerables } from 'chart.js';
import { customTooltips as cuiCustomTooltips } from '@coreui/chartjs';
import * as i0 from "@angular/core";
Chart.register(...registerables);
let nextId = 0;
export class ChartjsComponent {
    constructor(elementRef, ngZone, renderer) {
        this.elementRef = elementRef;
        this.ngZone = ngZone;
        this.renderer = renderer;
        this.customTooltips = true;
        this.id = `c-chartjs-${nextId++}`;
        this.plugins = [];
        this._redraw = false;
        this.type = 'bar';
        this.wrapper = true;
        this.getDatasetAtEvent = new EventEmitter();
        this.getElementAtEvent = new EventEmitter();
        this.getElementsAtEvent = new EventEmitter();
    }
    set height(value) {
        this._height = coerceNumberProperty(value);
    }
    get height() {
        return this._height;
    }
    set redraw(value) {
        this._redraw = coerceBooleanProperty(value);
    }
    get redraw() {
        return this._redraw;
    }
    set width(value) {
        this._width = coerceNumberProperty(value);
    }
    get width() {
        return this._width;
    }
    get hostClasses() {
        return {
            'chart-wrapper': this.wrapper
        };
    }
    ngAfterViewInit() {
        this.chartRender();
        // this.chartUpdate();
    }
    ngOnChanges(changes) {
        if (changes['data'] && !changes['data'].firstChange) {
            this.chartUpdate();
        }
    }
    ngOnDestroy() {
        this.chartDestroy();
    }
    handleOnClick($event) {
        if (!this.chart)
            return;
        const datasetAtEvent = this.chart.getElementsAtEventForMode($event, 'dataset', { intersect: true }, false);
        this.getDatasetAtEvent.emit(datasetAtEvent);
        const elementAtEvent = this.chart.getElementsAtEventForMode($event, 'nearest', { intersect: true }, false);
        this.getElementAtEvent.emit(elementAtEvent);
        const elementsAtEvent = this.chart.getElementsAtEventForMode($event, 'index', { intersect: true }, false);
        this.getElementsAtEvent.emit(elementsAtEvent);
    }
    chartDestroy() {
        this.chart?.destroy();
    }
    chartRender() {
        if (!this.canvasElement)
            return;
        const ctx = this.canvasElement.nativeElement.getContext('2d');
        this.ngZone.runOutsideAngular(() => {
            const config = this.chartConfig();
            if (config) {
                this.chart = new Chart(ctx, config);
                setTimeout(() => {
                    this.renderer.setStyle(this.canvasElement.nativeElement, 'display', 'block');
                });
            }
        });
    }
    chartUpdate() {
        if (!this.chart)
            return;
        if (this.redraw) {
            this.chartDestroy();
            setTimeout(() => {
                this.chartRender();
            });
            return;
        }
        const config = this.chartConfig();
        if (this.options) {
            // todo
            // @ts-ignore
            Object.assign(this.chart.options, config.options);
        }
        if (!this.chart.config.data) {
            this.chart.config.data = { ...config.data };
            this.chartUpdateOutsideAngular();
        }
        if (this.chart) {
            // todo
            // @ts-ignore
            Object.assign(this.chart.config.options, config.options);
            // todo
            // @ts-ignore
            Object.assign(this.chart.config.plugins, config.plugins);
            Object.assign(this.chart.config.data, config.data);
        }
        this.chartUpdateOutsideAngular();
    }
    chartUpdateOutsideAngular() {
        setTimeout(() => {
            this.ngZone.runOutsideAngular(() => {
                this.chart?.update();
            });
        });
    }
    chartToBase64Image() {
        return this.chart?.toBase64Image();
    }
    chartDataConfig() {
        return {
            labels: this.data?.labels ?? [],
            datasets: this.data?.datasets ?? []
        };
    }
    chartOptions() {
        return this.options;
    }
    chartConfig() {
        this.chartCustomTooltips();
        return {
            data: this.chartDataConfig(),
            options: this.chartOptions(),
            plugins: this.plugins,
            type: this.type
        };
    }
    chartCustomTooltips() {
        if (this.customTooltips) {
            const options = this.options;
            // @ts-ignore
            const plugins = this.options?.plugins;
            // @ts-ignore
            const tooltip = this.options?.plugins?.tooltip;
            this.options = merge({
                ...options,
                plugins: {
                    ...plugins,
                    tooltip: {
                        ...tooltip,
                        enabled: false,
                        mode: 'index',
                        position: 'nearest',
                        external: cuiCustomTooltips
                    }
                }
            });
        }
    }
    ;
}
ChartjsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ChartjsComponent, deps: [{ token: i0.ElementRef }, { token: i0.NgZone }, { token: i0.Renderer2 }], target: i0.ɵɵFactoryTarget.Component });
ChartjsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: ChartjsComponent, selector: "c-chart", inputs: { customTooltips: "customTooltips", data: "data", height: "height", id: "id", options: "options", plugins: "plugins", redraw: "redraw", type: "type", width: "width", wrapper: "wrapper" }, outputs: { getDatasetAtEvent: "getDatasetAtEvent", getElementAtEvent: "getElementAtEvent", getElementsAtEvent: "getElementsAtEvent" }, host: { properties: { "style.height.px": "this.height", "style.width.px": "this.width", "class": "this.hostClasses" } }, viewQueries: [{ propertyName: "canvasElement", first: true, predicate: ["canvasElement"], descendants: true }], exportAs: ["cChart"], usesOnChanges: true, ngImport: i0, template: "<canvas\r\n  #canvasElement\r\n  (click)=\"handleOnClick($event)\"\r\n  [height]=\"height\"\r\n  [id]=\"id\"\r\n  [width]=\"width\"\r\n  role=\"img\"\r\n  style=\"display: none;\"\r\n>\r\n  <ng-content></ng-content>\r\n</canvas>\r\n", styles: [":host.chart-wrapper{display:block}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ChartjsComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-chart', exportAs: 'cChart', template: "<canvas\r\n  #canvasElement\r\n  (click)=\"handleOnClick($event)\"\r\n  [height]=\"height\"\r\n  [id]=\"id\"\r\n  [width]=\"width\"\r\n  role=\"img\"\r\n  style=\"display: none;\"\r\n>\r\n  <ng-content></ng-content>\r\n</canvas>\r\n", styles: [":host.chart-wrapper{display:block}\n"] }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i0.NgZone }, { type: i0.Renderer2 }]; }, propDecorators: { customTooltips: [{
                type: Input
            }], data: [{
                type: Input
            }], height: [{
                type: HostBinding,
                args: ['style.height.px']
            }, {
                type: Input
            }], id: [{
                type: Input
            }], options: [{
                type: Input
            }], plugins: [{
                type: Input
            }], redraw: [{
                type: Input
            }], type: [{
                type: Input
            }], width: [{
                type: HostBinding,
                args: ['style.width.px']
            }, {
                type: Input
            }], wrapper: [{
                type: Input
            }], getDatasetAtEvent: [{
                type: Output
            }], getElementAtEvent: [{
                type: Output
            }], getElementsAtEvent: [{
                type: Output
            }], canvasElement: [{
                type: ViewChild,
                args: ['canvasElement']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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