import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./carousel.service";
export class CarouselState {
    constructor(carouselService) {
        this.carouselService = carouselService;
        this._state = {
            activeItemIndex: -1,
            animate: true,
            items: [],
            direction: 'next',
            transition: 'slide'
        };
    }
    get state() {
        return this._state;
    }
    set state(state) {
        const prevState = { ...this._state };
        const nextState = { ...this._state, ...state };
        this._state = nextState;
        if (prevState.activeItemIndex !== nextState.activeItemIndex) {
            const activeItemIndex = this.state.activeItemIndex || 0;
            const itemInterval = this.state.items && this.state.items[activeItemIndex]?.interval || -1;
            this.carouselService.setIndex({
                active: nextState.activeItemIndex,
                interval: itemInterval,
                lastItemIndex: (nextState.items?.length ?? 0) - 1
            });
        }
    }
    setItems(newItems) {
        if (newItems.length) {
            const itemsArray = newItems.toArray();
            itemsArray.forEach((item, i) => {
                item.index = i;
            });
            this.state = {
                items: itemsArray
            };
        }
        else {
            this.reset();
        }
    }
    setNextIndex(nextIndex) {
        this.carouselService.setIndex(nextIndex);
    }
    direction(direction = 'next') {
        this.state = { direction };
        const { activeItemIndex = -1, items } = this.state;
        const itemsCount = items?.length ?? 0;
        if (itemsCount > 0) {
            return direction === 'next' ?
                (activeItemIndex === itemsCount - 1 ? 0 : activeItemIndex + 1) :
                (activeItemIndex === 0 ? itemsCount - 1 : activeItemIndex - 1);
        }
        else {
            return 0;
        }
    }
    reset() {
        this.state = {
            activeItemIndex: -1,
            animate: true,
            items: [],
            direction: 'next',
            transition: 'slide'
        };
    }
}
CarouselState.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselState, deps: [{ token: i1.CarouselService }], target: i0.ɵɵFactoryTarget.Injectable });
CarouselState.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselState });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselState, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.CarouselService }]; } });
//# sourceMappingURL=data:application/json;base64,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