import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class FormCheckInputDirective {
    constructor(renderer, hostElement) {
        this.renderer = renderer;
        this.hostElement = hostElement;
        /**
         * Specifies the type of component.
         * @type {'checkbox' | 'radio'}
         * @default 'checkbox'
         */
        this.type = 'checkbox';
        this._indeterminate = false;
    }
    /**
     * Set component indeterminate state.
     * @type boolean
     */
    set indeterminate(value) {
        const newValue = coerceBooleanProperty(value);
        if (this._indeterminate !== newValue) {
            this._indeterminate = newValue;
            this.renderer.setProperty(this.hostElement.nativeElement, 'indeterminate', newValue);
        }
    }
    ;
    get indeterminate() {
        return this._indeterminate;
    }
    get hostClasses() {
        return {
            'form-check-input': true,
            'is-valid': this.valid === true,
            'is-invalid': this.valid === false
        };
    }
    get checked() {
        return this.hostElement?.nativeElement?.checked;
    }
}
FormCheckInputDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormCheckInputDirective, deps: [{ token: i0.Renderer2 }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
FormCheckInputDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: FormCheckInputDirective, selector: "input[cFormCheckInput]", inputs: { type: "type", indeterminate: "indeterminate", valid: "valid" }, host: { properties: { "attr.type": "this.type", "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: FormCheckInputDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'input[cFormCheckInput]'
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.ElementRef }]; }, propDecorators: { type: [{
                type: HostBinding,
                args: ['attr.type']
            }, {
                type: Input
            }], indeterminate: [{
                type: Input
            }], valid: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9ybS1jaGVjay1pbnB1dC5kaXJlY3RpdmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9jb3JldWktYW5ndWxhci9zcmMvbGliL2Zvcm0vZm9ybS1jaGVjay9mb3JtLWNoZWNrLWlucHV0LmRpcmVjdGl2ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFjLFdBQVcsRUFBRSxLQUFLLEVBQWEsTUFBTSxlQUFlLENBQUM7QUFDckYsT0FBTyxFQUFnQixxQkFBcUIsRUFBRSxNQUFNLHVCQUF1QixDQUFDOztBQUs1RSxNQUFNLE9BQU8sdUJBQXVCO0lBZ0RsQyxZQUNVLFFBQW1CLEVBQ25CLFdBQXVCO1FBRHZCLGFBQVEsR0FBUixRQUFRLENBQVc7UUFDbkIsZ0JBQVcsR0FBWCxXQUFXLENBQVk7UUE5Q2pDOzs7O1dBSUc7UUFFTSxTQUFJLEdBQTJCLFVBQVUsQ0FBQztRQWlCM0MsbUJBQWMsR0FBRyxLQUFLLENBQUM7SUF3QjNCLENBQUM7SUF2Q0w7OztPQUdHO0lBQ0gsSUFDSSxhQUFhLENBQUMsS0FBYztRQUM5QixNQUFNLFFBQVEsR0FBRyxxQkFBcUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM5QyxJQUFJLElBQUksQ0FBQyxjQUFjLEtBQUssUUFBUSxFQUFFO1lBQ3BDLElBQUksQ0FBQyxjQUFjLEdBQUcsUUFBUSxDQUFDO1lBQy9CLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxFQUFFLGVBQWUsRUFBRSxRQUFRLENBQUMsQ0FBQztTQUN0RjtJQUNILENBQUM7SUFBQSxDQUFDO0lBQ0YsSUFBSSxhQUFhO1FBQ2YsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFTRCxJQUNJLFdBQVc7UUFDYixPQUFPO1lBQ0wsa0JBQWtCLEVBQUUsSUFBSTtZQUN4QixVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssS0FBSyxJQUFJO1lBQy9CLFlBQVksRUFBRSxJQUFJLENBQUMsS0FBSyxLQUFLLEtBQUs7U0FDbkMsQ0FBQztJQUNKLENBQUM7SUFFRCxJQUFJLE9BQU87UUFDVCxPQUFPLElBQUksQ0FBQyxXQUFXLEVBQUUsYUFBYSxFQUFFLE9BQU8sQ0FBQztJQUNsRCxDQUFDOztvSEE5Q1UsdUJBQXVCO3dHQUF2Qix1QkFBdUI7MkZBQXZCLHVCQUF1QjtrQkFIbkMsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsd0JBQXdCO2lCQUNuQzt5SEFXVSxJQUFJO3NCQURaLFdBQVc7dUJBQUMsV0FBVzs7c0JBQ3ZCLEtBQUs7Z0JBT0YsYUFBYTtzQkFEaEIsS0FBSztnQkFpQkcsS0FBSztzQkFBYixLQUFLO2dCQUdGLFdBQVc7c0JBRGQsV0FBVzt1QkFBQyxPQUFPIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGlyZWN0aXZlLCBFbGVtZW50UmVmLCBIb3N0QmluZGluZywgSW5wdXQsIFJlbmRlcmVyMiB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBCb29sZWFuSW5wdXQsIGNvZXJjZUJvb2xlYW5Qcm9wZXJ0eSB9IGZyb20gJ0Bhbmd1bGFyL2Nkay9jb2VyY2lvbic7XHJcblxyXG5ARGlyZWN0aXZlKHtcclxuICBzZWxlY3RvcjogJ2lucHV0W2NGb3JtQ2hlY2tJbnB1dF0nXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBGb3JtQ2hlY2tJbnB1dERpcmVjdGl2ZSB7XHJcblxyXG4gIHN0YXRpYyBuZ0FjY2VwdElucHV0VHlwZV9pbmRldGVybWluYXRlOiBCb29sZWFuSW5wdXQ7XHJcblxyXG4gIC8qKlxyXG4gICAqIFNwZWNpZmllcyB0aGUgdHlwZSBvZiBjb21wb25lbnQuXHJcbiAgICogQHR5cGUgeydjaGVja2JveCcgfCAncmFkaW8nfVxyXG4gICAqIEBkZWZhdWx0ICdjaGVja2JveCdcclxuICAgKi9cclxuICBASG9zdEJpbmRpbmcoJ2F0dHIudHlwZScpXHJcbiAgQElucHV0KCkgdHlwZTogKCdjaGVja2JveCcgfCAncmFkaW8nKSA9ICdjaGVja2JveCc7XHJcblxyXG4gIC8qKlxyXG4gICAqIFNldCBjb21wb25lbnQgaW5kZXRlcm1pbmF0ZSBzdGF0ZS5cclxuICAgKiBAdHlwZSBib29sZWFuXHJcbiAgICovXHJcbiAgQElucHV0KClcclxuICBzZXQgaW5kZXRlcm1pbmF0ZSh2YWx1ZTogYm9vbGVhbikge1xyXG4gICAgY29uc3QgbmV3VmFsdWUgPSBjb2VyY2VCb29sZWFuUHJvcGVydHkodmFsdWUpO1xyXG4gICAgaWYgKHRoaXMuX2luZGV0ZXJtaW5hdGUgIT09IG5ld1ZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2luZGV0ZXJtaW5hdGUgPSBuZXdWYWx1ZTtcclxuICAgICAgdGhpcy5yZW5kZXJlci5zZXRQcm9wZXJ0eSh0aGlzLmhvc3RFbGVtZW50Lm5hdGl2ZUVsZW1lbnQsICdpbmRldGVybWluYXRlJywgbmV3VmFsdWUpO1xyXG4gICAgfVxyXG4gIH07XHJcbiAgZ2V0IGluZGV0ZXJtaW5hdGUoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5faW5kZXRlcm1pbmF0ZTtcclxuICB9XHJcbiAgcHJpdmF0ZSBfaW5kZXRlcm1pbmF0ZSA9IGZhbHNlO1xyXG5cclxuICAvKipcclxuICAgKiBTZXQgY29tcG9uZW50IHZhbGlkYXRpb24gc3RhdGUgdG8gdmFsaWQuXHJcbiAgICogQHR5cGUgYm9vbGVhblxyXG4gICAqL1xyXG4gIEBJbnB1dCgpIHZhbGlkPzogYm9vbGVhbjtcclxuXHJcbiAgQEhvc3RCaW5kaW5nKCdjbGFzcycpXHJcbiAgZ2V0IGhvc3RDbGFzc2VzKCk6IGFueSB7XHJcbiAgICByZXR1cm4ge1xyXG4gICAgICAnZm9ybS1jaGVjay1pbnB1dCc6IHRydWUsXHJcbiAgICAgICdpcy12YWxpZCc6IHRoaXMudmFsaWQgPT09IHRydWUsXHJcbiAgICAgICdpcy1pbnZhbGlkJzogdGhpcy52YWxpZCA9PT0gZmFsc2VcclxuICAgIH07XHJcbiAgfVxyXG5cclxuICBnZXQgY2hlY2tlZCgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLmhvc3RFbGVtZW50Py5uYXRpdmVFbGVtZW50Py5jaGVja2VkO1xyXG4gIH1cclxuXHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwcml2YXRlIHJlbmRlcmVyOiBSZW5kZXJlcjIsXHJcbiAgICBwcml2YXRlIGhvc3RFbGVtZW50OiBFbGVtZW50UmVmXHJcbiAgKSB7IH1cclxuXHJcbn1cclxuIl19