import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import * as i0 from "@angular/core";
export class IntersectionService {
    constructor() {
        this.intersecting = new BehaviorSubject(false);
        this.intersecting$ = this.intersecting.asObservable();
        this.defaultObserverOptions = {
            root: null,
            rootMargin: '0px',
            threshold: 0.2
        };
    }
    createIntersectionObserver(hostElement, observerOptions = this.defaultObserverOptions) {
        const options = { ...this.defaultObserverOptions, ...observerOptions };
        this.hostElement = hostElement;
        const handleIntersect = (entries, observer) => {
            entries.forEach((entry) => {
                this.intersecting.next(entry.isIntersecting);
            });
        };
        this.intersectionObserver = new IntersectionObserver(handleIntersect, options);
        this.intersectionObserver.observe(hostElement.nativeElement);
    }
    ngOnDestroy() {
        this.intersectionObserver?.unobserve(this.hostElement?.nativeElement);
    }
}
IntersectionService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: IntersectionService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
IntersectionService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: IntersectionService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: IntersectionService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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