//! moment.js locale configuration
//! locale : Georgian [ka]
//! author : Irakli Janiashvili : https://github.com/irakli-janiashvili
//! author : Levan Tskipuri : https://github.com/tskipa
export const kaLocale = {
    abbr: 'ka',
    months: {
        format: 'იანვარს_თებერვალს_მარტს_აპრილის_მაისს_ივნისს_ივლისს_აგვისტს_სექტემბერს_ოქტომბერს_ნოემბერს_დეკემბერს'.split('_'),
        standalone: 'იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი'.split('_')
    },
    monthsShort: 'იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ'.split('_'),
    weekdays: {
        standalone: 'კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი'.split('_'),
        format: 'კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს'.split('_'),
        isFormat: /(წინა|შემდეგ)/
    },
    weekdaysShort: 'კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ'.split('_'),
    weekdaysMin: 'კვ_ორ_სა_ოთ_ხუ_პა_შა'.split('_'),
    longDateFormat: {
        LT: 'h:mm A',
        LTS: 'h:mm:ss A',
        L: 'DD/MM/YYYY',
        LL: 'D MMMM YYYY',
        LLL: 'D MMMM YYYY h:mm A',
        LLLL: 'dddd, D MMMM YYYY h:mm A'
    },
    calendar: {
        sameDay: '[დღეს] LT[-ზე]',
        nextDay: '[ხვალ] LT[-ზე]',
        lastDay: '[გუშინ] LT[-ზე]',
        nextWeek: '[შემდეგ] dddd LT[-ზე]',
        lastWeek: '[წინა] dddd LT-ზე',
        sameElse: 'L'
    },
    relativeTime: {
        future(s) {
            var st = s.toString();
            return (/(წამი|წუთი|საათი|წელი)/).test(st) ?
                st.replace(/ი$/, 'ში') :
                st + 'ში';
        },
        past(s) {
            var st = s.toString();
            if ((/(წამი|წუთი|საათი|დღე|თვე)/).test(st)) {
                return st.replace(/(ი|ე)$/, 'ის წინ');
            }
            if ((/წელი/).test(st)) {
                return st.replace(/წელი$/, 'წლის წინ');
            }
        },
        s: 'რამდენიმე წამი',
        ss: '%d წამი',
        m: 'წუთი',
        mm: '%d წუთი',
        h: 'საათი',
        hh: '%d საათი',
        d: 'დღე',
        dd: '%d დღე',
        M: 'თვე',
        MM: '%d თვე',
        y: 'წელი',
        yy: '%d წელი'
    },
    dayOfMonthOrdinalParse: /0|1-ლი|მე-\d{1,2}|\d{1,2}-ე/,
    ordinal(_num, _period) {
        const num = Number(_num);
        if (num === 0) {
            return num.toString();
        }
        if (num === 1) {
            return num + '-ლი';
        }
        if ((num < 20) || (num <= 100 && (num % 20 === 0)) || (num % 100 === 0)) {
            return 'მე-' + num;
        }
        return num + '-ე';
    },
    week: {
        dow: 1,
        doy: 4
    }
};
//# sourceMappingURL=data:application/json;base64,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