// ! moment.js locale configuration
// ! locale : Kazakh [kk]
// ! authors : Nurlan Rakhimzhanov : https://github.com/nurlan
const suffixes = {
    0: '-ші',
    1: '-ші',
    2: '-ші',
    3: '-ші',
    4: '-ші',
    5: '-ші',
    6: '-шы',
    7: '-ші',
    8: '-ші',
    9: '-шы',
    10: '-шы',
    20: '-шы',
    30: '-шы',
    40: '-шы',
    50: '-ші',
    60: '-шы',
    70: '-ші',
    80: '-ші',
    90: '-шы',
    100: '-ші'
};
export const kkLocale = {
    abbr: 'kk',
    months: 'қаңтар_ақпан_наурыз_сәуір_мамыр_маусым_шілде_тамыз_қыркүйек_қазан_қараша_желтоқсан'.split('_'),
    monthsShort: 'қаң_ақп_нау_сәу_мам_мау_шіл_там_қыр_қаз_қар_жел'.split('_'),
    weekdays: 'жексенбі_дүйсенбі_сейсенбі_сәрсенбі_бейсенбі_жұма_сенбі'.split('_'),
    weekdaysShort: 'жек_дүй_сей_сәр_бей_жұм_сен'.split('_'),
    weekdaysMin: 'жк_дй_сй_ср_бй_жм_сн'.split('_'),
    longDateFormat: {
        LT: 'HH:mm',
        LTS: 'HH:mm:ss',
        L: 'DD.MM.YYYY',
        LL: 'D MMMM YYYY',
        LLL: 'D MMMM YYYY HH:mm',
        LLLL: 'dddd, D MMMM YYYY HH:mm'
    },
    calendar: {
        sameDay: '[Бүгін сағат] LT',
        nextDay: '[Ертең сағат] LT',
        nextWeek: 'dddd [сағат] LT',
        lastDay: '[Кеше сағат] LT',
        lastWeek: '[Өткен аптаның] dddd [сағат] LT',
        sameElse: 'L'
    },
    relativeTime: {
        future: '%s ішінде',
        past: '%s бұрын',
        s: 'бірнеше секунд',
        ss: '%d секунд',
        m: 'бір минут',
        mm: '%d минут',
        h: 'бір сағат',
        hh: '%d сағат',
        d: 'бір күн',
        dd: '%d күн',
        M: 'бір ай',
        MM: '%d ай',
        y: 'бір жыл',
        yy: '%d жыл'
    },
    dayOfMonthOrdinalParse: /\d{1,2}-(ші|шы)/,
    ordinal(_num) {
        const a = _num % 10;
        const b = _num >= 100 ? 100 : null;
        return _num + (suffixes[_num] || suffixes[a] || suffixes[b]);
    },
    week: {
        dow: 1,
        doy: 7 // The week that contains Jan 7th is the first week of the year.
    }
};
//# sourceMappingURL=data:application/json;base64,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