// Pick a moment m from moments so that m[fn](other) is true for all
// other. This relies on the function fn to be transitive.
//
// moments should either be an array of moment objects or an array, whose
// first element is an array of moment objects.
import { isArray, isDateValid } from '../utils/type-checks';
import { isAfter, isBefore } from '../utils/date-compare';
function pickBy(fn, dates) {
    let _dates;
    const _firstArg = dates[0];
    if (isArray(_firstArg) && dates.length === 1) {
        _dates = _firstArg;
    }
    else if (isArray(dates)) {
        _dates = dates;
    }
    if (!_dates || !_dates.length) {
        return new Date();
    }
    let res = _dates[0];
    for (let i = 1; i < _dates.length; ++i) {
        // if (!moments[i].isValid() || moments[i][fn](res)) {
        if (!isDateValid(_dates[i]) || fn.call(null, _dates[i], res)) {
            res = _dates[i];
        }
    }
    return res;
}
// TODO: Use [].sort instead?
export function min(...args) {
    // const args = [].slice.call(arguments, 0);
    return pickBy(isBefore, args);
}
export function max(...args) {
    // const args = [].slice.call(arguments, 0);
    return pickBy(isAfter, args);
}
//# sourceMappingURL=data:application/json;base64,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