<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\Bank;
use Illuminate\Http\Request;

class BranchController extends Controller
{
    /**
     * Branch List
     */
    public function index()
    {
        $branches = Branch::with('bank')->latest()->paginate(10);
        return view('admin.branch.index', compact('branches')); // ✅ plural
    }

    /**
     * Show Create Form
     */
    public function create()
    {
        $banks = Bank::active()->get();
        return view('admin.branch.create', compact('banks')); // ✅ plural
    }

    /**
     * Store Branch
     */
    public function store(Request $request)
    {
        $request->validate([
            'bank_id' => 'required|exists:banks,id',
            'branch_address' => 'required|string|max:255',
            'is_active' => 'required|boolean',
        ]);

        $data = $request->only(['bank_id', 'branch_address', 'is_active']);

        Branch::create($data);

        return redirect()->route('admin.branch.index')->with('success', 'Branch created successfully!'); // ✅ plural
    }

    /**
     * Show Edit Form
     */
    public function edit(Branch $branch)
    {
        $banks = Bank::active()->get();
        return view('admin.branch.edit', compact('branch', 'banks')); // ✅ plural
    }

    /**
     * Update Branch
     */
    public function update(Request $request, Branch $branch)
    {
        $request->validate([
            'bank_id' => 'required|exists:banks,id',
            'branch_address' => 'required|string|max:255',
            'is_active' => 'required|boolean',
        ]);

        $data = $request->only(['bank_id', 'branch_address', 'is_active']);

        $branch->update($data);

        return redirect()->route('admin.branch.index')->with('success', 'Branch updated successfully!'); // ✅ plural
    }

    /**
     * Delete Branch
     */
    public function destroy(Branch $branch)
    {
        $branch->delete();
        return redirect()->route('admin.branch.index')->with('success', 'Branch deleted successfully!'); // ✅ plural
    }
}
