<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Agent extends Authenticatable
{
    use HasFactory;

    protected $fillable = [
        'bank_id',
        'branch_id',
        'designation',
        'name',
        'email',
        'password',
        'mobile_number',
        "whatsapp_number",
        'image',
        'is_active',
    ];

    protected $hidden = [
        'password',
    ];

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }
    public function tokens()
    {
        return $this->hasMany(AgentToken::class, 'agent_id');
    }

}
