<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    protected $fillable = [
        'image',
        'is_active',
        'branch_address',   // ✅ Branch Address
        'bank_id',          // ✅ Bank Foreign Key
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * ✅ Relation: Branch belongs to Bank
     */
    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }
}
