<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoldItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'description',
        'quantity',
        'gross_weight',
        'stone_weight',
        'net_weight',
        'purity',
        'rate_per_gram',
        'market_value',
        'remarks'
    ];

    // relation with Customer
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
