@extends('admin.layouts.app')

@section('title', 'Gold Items')

@section('content')
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">Gold Items</h4>
                    <a href="{{ route('admin.gold_items.create') }}" class="btn btn-primary btn-sm">
                        <i class="fa fa-plus"></i> Add Gold Item
                    </a>
                </div>
                <div class="card-body">

                    {{-- Flash Messages --}}
                    @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if (session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    {{-- Table --}}
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Customer</th>
                                    <th>Description</th>
                                    <th>Qty</th>
                                    <th>Gross Wt</th>
                                    <th>Stone Wt</th>
                                    <th>Net Wt</th>
                                    <th>Purity</th>
                                    <th>Rate/gm</th>
                                    <th>Market Value</th>
                                    <th>Remarks</th>
                                    <th>Created At</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($golditems as $item)
                                    <tr>
                                        <td>{{ $loop->iteration + ($golditems->currentPage() - 1) * $golditems->perPage() }}
                                        </td>
                                        <td>{{ $item->customer->full_name ?? 'N/A' }}</td>
                                        <td>{{ $item->description }}</td>
                                        <td>{{ $item->quantity }}</td>
                                        <td>{{ $item->gross_weight }}</td>
                                        <td>{{ $item->stone_weight }}</td>
                                        <td>{{ $item->net_weight }}</td>
                                        <td>{{ $item->purity }}k</td>
                                        <td>{{ number_format($item->rate_per_gram, 2) }}</td>
                                        <td>{{ number_format($item->market_value, 2) }}</td>
                                        <td>{{ $item->remarks }}</td>
                                        <td>{{ $item->created_at->format('d-m-Y H:i') }}</td>
                                        <td>
                                            <a href="{{ route('admin.gold_items.edit', $item->id) }}"
                                                class="btn btn-sm btn-warning">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.gold_items.destroy', $item->id) }}" method="POST"
                                                class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger"
                                                    onclick="return confirm('Are you sure you want to delete this item?')">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="13" class="text-center">No gold items found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    {{-- Pagination --}}
                    <div class="mt-3">
                        {{ $golditems->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">

@endsection