<!doctype html>
<html lang="en" data-bs-theme="light">

<head>
    <meta charset="utf-8" />
    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard'); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/assets/images/logo.webp')); ?>">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.2.0/fonts/remixicon.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

    <style>
        /* Modern Color Palette & Fonts */
        :root {
            --sidebar-bg: #1e293b;
            /* Dark Slate */
            --sidebar-link-color: #cbd5e1;
            /* Light Slate */
            --sidebar-link-hover-bg: #334155;
            /* Mid Slate */
            --sidebar-link-active-color: #ffffff;
            --primary-accent: #3b82f6;
            /* Bright Blue */
            --content-bg: #f8fafc;
            /* Very Light Gray */
            --topbar-bg: #ffffff;
            --border-color: #e2e8f0;
            /* Light Border */
            --body-text-color: #475569;
        }

        body {
            background-color: var(--content-bg);
            color: var(--body-text-color);
            font-family: 'Inter', sans-serif;
            /* A cleaner font, add via Google Fonts if needed */
        }

        /*
        ==================================
        |          MAIN LAYOUT          |
        ==================================
        */
        #layout-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .main-content {
            margin-left: 250px;
            padding-top: 70px;
            /* Space for fixed topbar */
            transition: margin-left 0.3s ease-in-out;
        }

        .page-content {
            padding: 1.5rem;
        }

        /*
        ==================================
        |            TOP BAR            |
        ==================================
        */
        #page-topbar {
            position: fixed;
            top: 0;
            right: 0;
            left: 250px;
            z-index: 1002;
            background-color: var(--topbar-bg);
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.05);
            height: 70px;
            transition: left 0.3s ease-in-out;
        }

        .navbar-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 100%;
            padding: 0 1.5rem;
        }

        #topnav-hamburger-icon {
            border: none;
            background: transparent;
        }

        /*
        ==================================
        |             SIDEBAR            |
        ==================================
        */
        .app-menu {
            width: 250px;
            background: var(--sidebar-bg);
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            overflow-y: auto;
            z-index: 1005;
            transition: transform 0.3s ease-in-out, width 0.3s ease-in-out;
            display: flex;
            flex-direction: column;
        }

        .navbar-brand-box {
            padding: 1rem;
            text-align: center;
            height: 70px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .navbar-brand-box .logo-light {
            display: inline-block;
        }

        .navbar-brand-box .logo-sm {
            display: none;
        }

        .navbar-nav {
            padding: 1rem;
            flex-grow: 1;
        }

        .nav-item {
            margin-bottom: 0.25rem;
        }

        .app-menu .nav-link {
            color: var(--sidebar-link-color) !important;
            padding: 12px 15px;
            border-radius: 6px;
            font-size: 0.95rem;
            display: flex;
            align-items: center;
            transition: background-color 0.2s ease, color 0.2s ease;
        }

        .app-menu .nav-link i {
            font-size: 1.2rem;
            min-width: 30px;
        }

        .app-menu .nav-link .menu-title {
            opacity: 1;
            transition: opacity 0.2s ease-in-out;
        }

        .app-menu .nav-link:hover {
            background-color: var(--sidebar-link-hover-bg);
            color: var(--sidebar-link-active-color) !important;
        }

        .app-menu .nav-link.active,
        .app-menu .nav-link[aria-expanded="true"] {
            background-color: var(--sidebar-link-hover-bg);
            color: var(--sidebar-link-active-color) !important;
            font-weight: 500;
        }

        /* Sub-menu styling */
        .collapse .nav-link {
            padding-left: 55px;
            /* Indent sub-menu items */
            font-size: 0.9rem;
            color: var(--sidebar-link-color) !important;
        }

        .collapse .nav-link:hover {
            background: transparent;
        }

        .collapse .nav-link.active {
            color: var(--sidebar-link-active-color) !important;
            font-weight: 500;
            background: transparent;
        }

        /* Logout button styling */
        .logout-btn {
            background: none;
            border: none;
            color: var(--sidebar-link-color) !important;
            padding: 12px 15px;
            border-radius: 6px;
            font-size: 0.95rem;
            display: flex;
            align-items: center;
            width: 100%;
            text-align: left;
            transition: background-color 0.2s ease, color 0.2s ease;
        }

        .logout-btn:hover {
            background-color: var(--sidebar-link-hover-bg);
            color: var(--sidebar-link-active-color) !important;
        }

        /*
        ==================================
        |       COLLAPSED SIDEBAR        |
        ==================================
        */
        body.vertical-collapsed .app-menu {
            width: 80px;
        }

        body.vertical-collapsed .main-content,
        body.vertical-collapsed #page-topbar {
            margin-left: 80px;
            left: 80px;
        }

        body.vertical-collapsed .menu-title,
        body.vertical-collapsed .navbar-brand-box .logo-light {
            opacity: 0;
            width: 0;
            display: none;
        }

        body.vertical-collapsed .navbar-brand-box .logo-sm {
            display: inline-block;
        }

        body.vertical-collapsed .app-menu .nav-link {
            justify-content: center;
        }

        body.vertical-collapsed .collapse {
            display: none !important;
        }

        /*
        ==================================
        |       MOBILE RESPONSIVE        |
        ==================================
        */
        .vertical-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1004;
        }

        @media (max-width: 991.98px) {
            .app-menu {
                transform: translateX(-100%);
            }

            body.sidebar-enable .app-menu {
                transform: translateX(0);
            }

            .main-content,
            #page-topbar {
                margin-left: 0 !important;
                left: 0 !important;
            }

            .vertical-overlay {
                display: block;
            }

            body.sidebar-enable .vertical-overlay {
                opacity: 1;
                visibility: visible;
            }

            body:not(.sidebar-enable) .vertical-overlay {
                opacity: 0;
                visibility: hidden;
            }
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body>
    <div id="layout-wrapper">
        <header id="page-topbar">
            <div class="navbar-header">
                <div class="d-flex align-items-center">
                    <button type="button" id="topnav-hamburger-icon" class="btn btn-sm px-3 fs-16">
                        <i class="ri-menu-2-line"></i>
                    </button>
                </div>

                <div class="dropdown">
                    <button class="btn btn-light dropdown-toggle" type="button" id="userMenu" data-bs-toggle="dropdown"
                        aria-expanded="false">
                        <i class="ri-user-line align-middle me-1"></i>
                        <?php echo e(Auth::guard('admin')->user()->name); ?>

                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?php echo e(route('admin.change-credentials')); ?>">Change
                                Credentials</a></li>
                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li>
                            <form method="POST" action="<?php echo e(route('admin.logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-item text-danger">
                                    <i class="ri-logout-box-r-line align-middle me-1"></i> Logout
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </header>

        <div class="app-menu navbar-menu">
            <div class="navbar-brand-box">
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <img src="<?php echo e(asset('assets/assets/images/users/loan.jpg')); ?>" alt="Logo" height="50"
                        class="logo-light">
                    <img src="<?php echo e(asset('assets/assets/images/users/loan.jpg')); ?>" alt="Logo" height="30"
                        class="logo-sm">
                </a>
            </div>

            <ul class="navbar-nav" id="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">
                        <i class="ri-dashboard-2-line"></i> <span class="menu-title">Dashboard</span>
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#customersMenu" role="button"
                        aria-expanded="false">
                        <i class="ri-user-line"></i> <span class="menu-title">Customers</span>
                    </a>
                    <div class="collapse" id="customersMenu" data-bs-parent="#navbar-nav">
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.customers.index')); ?>">All
                                    Customers</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.contacts.index')); ?>">Customer
                                    Enquiries</a></li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#goldItemsMenu" role="button"
                        aria-expanded="false">
                        <i class="ri-coins-line"></i> <span class="menu-title">Gold Items</span>
                    </a>
                    <div class="collapse" id="goldItemsMenu" data-bs-parent="#navbar-nav">
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link"
                                    href="<?php echo e(route('admin.gold_items.create')); ?>">Create Gold Item</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.gold_items.index')); ?>">View
                                    Gold Items</a></li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#banksMenu" role="button" aria-expanded="false">
                        <i class="ri-bank-line"></i> <span class="menu-title">Banks</span>
                    </a>
                    <div class="collapse" id="banksMenu" data-bs-parent="#navbar-nav">
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.bank.index')); ?>">List
                                    Banks</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.bank.create')); ?>">Create
                                    Bank</a></li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#branchMenu" role="button"
                        aria-expanded="false">
                        <i class="ri-building-2-line"></i> <span class="menu-title">Branches</span>
                    </a>
                    <div class="collapse" id="branchMenu" data-bs-parent="#navbar-nav">
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.branch.index')); ?>">List
                                    Branches</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.branch.create')); ?>">Create
                                    Branch</a></li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="collapse" href="#agentsMenu" role="button"
                        aria-expanded="false">
                        <i class="ri-user-3-line"></i> <span class="menu-title">Agents</span>
                    </a>
                    <div class="collapse" id="agentsMenu" data-bs-parent="#navbar-nav">
                        <ul class="nav flex-column">
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.agent.index')); ?>">List
                                    Agents</a></li>
                            <li class="nav-item"><a class="nav-link" href="<?php echo e(route('admin.agent.create')); ?>">Create
                                    Agent</a></li>
                        </ul>
                    </div>
                </li>

                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.invoices')); ?>">
                        <i class="ri-receipt-line"></i> <span class="menu-title">Invoice</span>
                    </a>
                </li>
            </ul>

            <div class="p-3 mt-auto">
                <form method="POST" action="<?php echo e(route('admin.logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="logout-btn">
                        <i class="ri-logout-box-r-line"></i>
                        <span class="menu-title">Logout</span>
                    </button>
                </form>
            </div>
        </div>

        <div class="vertical-overlay"></div>

        <div class="main-content">
            <div class="page-content">
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        $(function () {
            // --- Helper Function to manage sidebar state ---
            function manageSidebarView() {
                const windowWidth = $(window).width();
                if (windowWidth < 992) {
                    $('body').removeClass('vertical-collapsed'); // Exit desktop collapsed mode
                } else {
                    $('body').removeClass('sidebar-enable'); // Exit mobile slide-in mode
                }
            }

            // --- Sidebar Toggle Handler ---
            $('#topnav-hamburger-icon').on('click', function () {
                if ($(window).width() < 992) {
                    $('body').toggleClass('sidebar-enable');
                } else {
                    $('body').toggleClass('vertical-collapsed');
                }
            });

            // --- Close mobile sidebar on overlay click ---
            $('.vertical-overlay').on('click', function () {
                $('body').removeClass('sidebar-enable');
            });

            // --- Set Active Menu Item ---
            // This part ensures the current page's link is active.
            const currentUrl = window.location.href.split(/[?#]/)[0];
            $(".app-menu .nav-link").each(function () {
                if ($(this).attr('href') === currentUrl) {
                    $(this).addClass('active');
                    // If it's in a collapsed menu, open the parent
                    const parentCollapse = $(this).closest('.collapse');
                    if (parentCollapse.length) {
                        parentCollapse.addClass('show');
                        // Also activate the parent menu link
                        $('a[href="#' + parentCollapse.attr('id') + '"]').addClass('active').attr('aria-expanded', true);
                    }
                }
            });

            // --- Auto close mobile sidebar after a menu link click ---
            $('.app-menu a').on('click', function (e) {
                // If it's a collapsible link, don't close the menu
                if ($(this).attr('data-bs-toggle') === 'collapse') {
                    return;
                }
                if ($(window).width() < 992 && $('body').hasClass('sidebar-enable')) {
                    $('body').removeClass('sidebar-enable');
                }
            });

            // --- Window Resize Listener ---
            $(window).on('resize', manageSidebarView);

            // --- Initialize View on Load ---
            manageSidebarView();
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\Users\LENOVO\Desktop\loanmanagement\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>