<?php $__env->startSection('title', 'Agents List'); ?>

<?php $__env->startPush('styles'); ?>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <h4 class="mb-0">All Agents</h4>
            <a href="<?php echo e(route('admin.agent.create')); ?>" class="btn btn-success btn-sm">
                <i class="bi bi-plus-circle"></i> Add Agent
            </a>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success" id="success-alert"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Bank</th>
                            <th>Branch</th>
                            <th>Designation</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>mobile_number</th>
                            <th>whatsapp_number</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($agent->id); ?></td>
                                <td><?php echo e($agent->bank->bank ?? 'N/A'); ?></td>
                                <td><?php echo e($agent->branch->branch_address ?? 'N/A'); ?></td>
                                <td><?php echo e($agent->designation); ?></td>
                                <td><?php echo e($agent->name); ?></td>
                                <td><?php echo e($agent->email); ?></td>
                                <td><?php echo e($agent->mobile_number); ?></td>
                                <td><?php echo e($agent->whatsapp_number); ?></td>
                                <td>
                                    <?php if($agent->image): ?>
                                        <img src="<?php echo e(asset('storage/' . $agent->image)); ?>" width="50" class="rounded">
                                    <?php else: ?>
                                        <span class="text-muted">No Image</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($agent->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.agent.edit', $agent->id)); ?>" class="btn btn-sm btn-primary">
                                        <i class="bi bi-pencil-square"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.agent.destroy', $agent->id)); ?>" method="POST"
                                        class="d-inline">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this agent?')">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center">No agents found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php echo e($agents->links()); ?>

        </div>
    </div>

    
    <?php $__env->startPush('scripts'); ?>
        <script>
            setTimeout(() => {
                let alert = document.getElementById('success-alert');
                if (alert) {
                    alert.style.display = 'none';
                }
            }, 2000);
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\LENOVO\Desktop\loanmanagement\resources\views/admin/agent/index.blade.php ENDPATH**/ ?>