<?php

/** --------------------------------------------------------------------------------
 * This classes renders the response for the [clone] process for the projects
 * controller
 * @package    Grow CRM
 * @author     NextLoop
 *----------------------------------------------------------------------------------*/

namespace App\Http\Responses\Projects;
use Illuminate\Contracts\Support\Responsable;

class StoreCloneResponse implements Responsable {

    private $payload;

    public function __construct($payload = array()) {
        $this->payload = $payload;
    }

    /**
     * render the view for projects
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function toResponse($request) {

        //set all data to arrays
        foreach ($this->payload as $key => $value) {
            $$key = $value;
        }

        //succes message
        request()->session()->flash('success-notification', __('lang.request_has_been_completed'));

        //redirect
        $jsondata['redirect_url'] = url("projects/$project_id");

        //ajax response
        return response()->json($jsondata);
    }
}