/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Always use __globalThis if available, which is the spec-defined global variable across all
// environments, then fallback to __global first, because in Node tests both __global and
// __window may be defined and _global should be __global in that case. Note: Typeof/Instanceof
// checks are considered side-effects in Terser. We explicitly mark this as side-effect free:
// https://github.com/terser/terser/issues/250.
export const _global = ( /* @__PURE__ */(() => (typeof globalThis !== 'undefined' && globalThis) ||
    (typeof global !== 'undefined' && global) || (typeof window !== 'undefined' && window) ||
    (typeof self !== 'undefined' && typeof WorkerGlobalScope !== 'undefined' &&
        self instanceof WorkerGlobalScope && self))());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2xvYmFsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvbG9jYWxpemUvc3JjL2xvY2FsaXplL3NyYy9nbG9iYWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBb0JILDZGQUE2RjtBQUM3Rix5RkFBeUY7QUFDekYsK0ZBQStGO0FBQy9GLDZGQUE2RjtBQUM3RiwrQ0FBK0M7QUFDL0MsTUFBTSxDQUFDLE1BQU0sT0FBTyxHQUFRLEVBQUMsZUFBZ0IsQ0FDekMsR0FBRyxFQUFFLENBQUMsQ0FBQyxPQUFPLFVBQVUsS0FBSyxXQUFXLElBQUksVUFBVSxDQUFDO0lBQ25ELENBQUMsT0FBTyxNQUFNLEtBQUssV0FBVyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxNQUFNLEtBQUssV0FBVyxJQUFJLE1BQU0sQ0FBQztJQUN0RixDQUFDLE9BQU8sSUFBSSxLQUFLLFdBQVcsSUFBSSxPQUFPLGlCQUFpQixLQUFLLFdBQVc7UUFDdkUsSUFBSSxZQUFZLGlCQUFpQixJQUFJLElBQUksQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbi8vICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbi8vIFRoaXMgY29kZSB0byBhY2Nlc3MgdGhlIGdsb2JhbCBvYmplY3QgaXMgbW9zdGx5IGNvcGllZCBmcm9tIGBwYWNrYWdlcy9jb3JlL3NyYy91dGlsL2dsb2JhbC50c2BcblxuZGVjbGFyZSBnbG9iYWwge1xuICAvLyBUaGUgZGVmaW5pdGlvbiBvZiBgV29ya2VyR2xvYmFsU2NvcGVgIG11c3QgYmUgY29tcGF0aWJsZSB3aXRoIHRoZSBvbmUgaW4gYGxpYi53ZWJ3b3JrZXIuZC50c2AsXG4gIC8vIGJlY2F1c2UgYWxsIGZpbGVzIHVuZGVyIGBwYWNrYWdlcy9gIGFyZSBjb21waWxlZCB0b2dldGhlciBhcyBwYXJ0IG9mIHRoZVxuICAvLyBbbGVnYWN5LXVuaXQtdGVzdHMtc2F1Y2VsYWJzXVsxXSBDSSBqb2IsIGluY2x1ZGluZyB0aGUgYGxpYi53ZWJ3b3JrZXIuZC50c2AgdHlwaW5ncyBicm91Z2h0IGluXG4gIC8vIGJ5IFtzZXJ2aWNlLXdvcmtlci93b3JrZXIvc3JjL3NlcnZpY2Utd29ya2VyLmQudHNdWzJdLlxuICAvL1xuICAvLyBbMV06XG4gIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9hbmd1bGFyL2FuZ3VsYXIvYmxvYi9mZmVlYTYzZjQzZTZhN2ZkNDZiZTRhOGNkNWE1ZDI1NGM5OGRlYTA4Ly5jaXJjbGVjaS9jb25maWcueW1sI0w2ODFcbiAgLy8gWzJdOlxuICAvLyBodHRwczovL2dpdGh1Yi5jb20vYW5ndWxhci9hbmd1bGFyL2Jsb2IvMzE2ZGMyZjEyY2U4OTMxZjVmZjY2ZmE1ZjhkYTIxYzBkMjUxYTMzNy9wYWNrYWdlcy9zZXJ2aWNlLXdvcmtlci93b3JrZXIvc3JjL3NlcnZpY2Utd29ya2VyLmQudHMjTDlcbiAgaW50ZXJmYWNlIFdvcmtlckdsb2JhbFNjb3BlIGV4dGVuZHMgRXZlbnRUYXJnZXQsIFdpbmRvd09yV29ya2VyR2xvYmFsU2NvcGUge31cblxuICB2YXIgV29ya2VyR2xvYmFsU2NvcGU6IHtwcm90b3R5cGU6IFdvcmtlckdsb2JhbFNjb3BlOyBuZXcgKCk6IFdvcmtlckdsb2JhbFNjb3BlO307XG59XG5cbi8vIEFsd2F5cyB1c2UgX19nbG9iYWxUaGlzIGlmIGF2YWlsYWJsZSwgd2hpY2ggaXMgdGhlIHNwZWMtZGVmaW5lZCBnbG9iYWwgdmFyaWFibGUgYWNyb3NzIGFsbFxuLy8gZW52aXJvbm1lbnRzLCB0aGVuIGZhbGxiYWNrIHRvIF9fZ2xvYmFsIGZpcnN0LCBiZWNhdXNlIGluIE5vZGUgdGVzdHMgYm90aCBfX2dsb2JhbCBhbmRcbi8vIF9fd2luZG93IG1heSBiZSBkZWZpbmVkIGFuZCBfZ2xvYmFsIHNob3VsZCBiZSBfX2dsb2JhbCBpbiB0aGF0IGNhc2UuIE5vdGU6IFR5cGVvZi9JbnN0YW5jZW9mXG4vLyBjaGVja3MgYXJlIGNvbnNpZGVyZWQgc2lkZS1lZmZlY3RzIGluIFRlcnNlci4gV2UgZXhwbGljaXRseSBtYXJrIHRoaXMgYXMgc2lkZS1lZmZlY3QgZnJlZTpcbi8vIGh0dHBzOi8vZ2l0aHViLmNvbS90ZXJzZXIvdGVyc2VyL2lzc3Vlcy8yNTAuXG5leHBvcnQgY29uc3QgX2dsb2JhbDogYW55ID0gKC8qIEBfX1BVUkVfXyAqLyAoXG4gICAgKCkgPT4gKHR5cGVvZiBnbG9iYWxUaGlzICE9PSAndW5kZWZpbmVkJyAmJiBnbG9iYWxUaGlzKSB8fFxuICAgICAgICAodHlwZW9mIGdsb2JhbCAhPT0gJ3VuZGVmaW5lZCcgJiYgZ2xvYmFsKSB8fCAodHlwZW9mIHdpbmRvdyAhPT0gJ3VuZGVmaW5lZCcgJiYgd2luZG93KSB8fFxuICAgICAgICAodHlwZW9mIHNlbGYgIT09ICd1bmRlZmluZWQnICYmIHR5cGVvZiBXb3JrZXJHbG9iYWxTY29wZSAhPT0gJ3VuZGVmaW5lZCcgJiZcbiAgICAgICAgIHNlbGYgaW5zdGFuY2VvZiBXb3JrZXJHbG9iYWxTY29wZSAmJiBzZWxmKSkoKSk7XG4iXX0=