import { Component, Input } from '@angular/core';
import { Observable } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "./breadcrumb-router.service";
import * as i2 from "@angular/common";
import * as i3 from "../breadcrumb-item/breadcrumb-item.component";
import * as i4 from "../breadcrumb/breadcrumb.component";
export class BreadcrumbRouterComponent {
    constructor(service) {
        this.service = service;
    }
    ngOnInit() {
        this.breadcrumbs = this.service.breadcrumbs$;
    }
    ngOnChanges(changes) {
        if (changes['items']) {
            this.setup();
        }
    }
    setup() {
        if (this.items && this.items.length > 0) {
            this.breadcrumbs = new Observable((observer) => {
                if (this.items) {
                    observer.next(this.items);
                }
            });
        }
    }
    ngOnDestroy() {
        this.breadcrumbs = undefined;
    }
}
BreadcrumbRouterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BreadcrumbRouterComponent, deps: [{ token: i1.BreadcrumbRouterService }], target: i0.ɵɵFactoryTarget.Component });
BreadcrumbRouterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: BreadcrumbRouterComponent, selector: "c-breadcrumb-router, [cBreadcrumbRouter]", inputs: { items: "items" }, usesOnChanges: true, ngImport: i0, template: "<c-breadcrumb class=\"m-0\">\n  <ng-template ngFor let-breadcrumb [ngForOf]=\"breadcrumbs | async\" let-last=\"last\">\n    <ng-container *ngIf=\"breadcrumb?.label && (breadcrumb?.url?.slice(-1) === '/' || last)\">\n      <c-breadcrumb-item\n        [active]=\"last\"\n        [url]=\"breadcrumb?.url\"\n        [attributes]=\"breadcrumb?.attributes\"\n        [linkProps]=\"breadcrumb?.linkProps\"\n      >\n        {{ breadcrumb?.label }}\n      </c-breadcrumb-item>\n    </ng-container>\n  </ng-template>\n</c-breadcrumb>\n", styles: [""], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.BreadcrumbItemComponent, selector: "c-breadcrumb-item", inputs: ["active", "url", "attributes", "linkProps"] }, { kind: "component", type: i4.BreadcrumbComponent, selector: "c-breadcrumb", inputs: ["ariaLabel", "role"] }, { kind: "pipe", type: i2.AsyncPipe, name: "async" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BreadcrumbRouterComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-breadcrumb-router, [cBreadcrumbRouter]', template: "<c-breadcrumb class=\"m-0\">\n  <ng-template ngFor let-breadcrumb [ngForOf]=\"breadcrumbs | async\" let-last=\"last\">\n    <ng-container *ngIf=\"breadcrumb?.label && (breadcrumb?.url?.slice(-1) === '/' || last)\">\n      <c-breadcrumb-item\n        [active]=\"last\"\n        [url]=\"breadcrumb?.url\"\n        [attributes]=\"breadcrumb?.attributes\"\n        [linkProps]=\"breadcrumb?.linkProps\"\n      >\n        {{ breadcrumb?.label }}\n      </c-breadcrumb-item>\n    </ng-container>\n  </ng-template>\n</c-breadcrumb>\n" }]
        }], ctorParameters: function () { return [{ type: i1.BreadcrumbRouterService }]; }, propDecorators: { items: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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