import { createDuration } from './create';
let round = Math.round;
const thresholds = {
    ss: 44,
    s: 45,
    m: 45,
    h: 22,
    d: 26,
    M: 11 // months to year
};
// helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
function substituteTimeAgo(str, num, withoutSuffix, isFuture, locale) {
    return locale.relativeTime(num || 1, !!withoutSuffix, str, isFuture);
}
export function relativeTime(posNegDuration, withoutSuffix, locale) {
    const duration = createDuration(posNegDuration).abs();
    const seconds = round(duration.as('s'));
    const minutes = round(duration.as('m'));
    const hours = round(duration.as('h'));
    const days = round(duration.as('d'));
    const months = round(duration.as('M'));
    const years = round(duration.as('y'));
    const a = seconds <= thresholds["ss"] && ['s', seconds] ||
        seconds < thresholds["s"] && ['ss', seconds] ||
        minutes <= 1 && ['m'] ||
        minutes < thresholds["m"] && ['mm', minutes] ||
        hours <= 1 && ['h'] ||
        hours < thresholds["h"] && ['hh', hours] ||
        days <= 1 && ['d'] ||
        days < thresholds["d"] && ['dd', days] ||
        months <= 1 && ['M'] ||
        months < thresholds["M"] && ['MM', months] ||
        years <= 1 && ['y'] || ['yy', years];
    const b = [a[0], a[1], withoutSuffix, +posNegDuration > 0, locale];
    // a[2] = withoutSuffix;
    // a[3] = +posNegDuration > 0;
    // a[4] = locale;
    return substituteTimeAgo.apply(null, b);
}
// This function allows you to set the rounding function for relative time strings
export function getSetRelativeTimeRounding(roundingFunction) {
    if (roundingFunction === undefined) {
        return round;
    }
    if (typeof (roundingFunction) === 'function') {
        round = roundingFunction;
        return true;
    }
    return false;
}
// This function allows you to set a threshold for relative time strings
export function getSetRelativeTimeThreshold(threshold, limit) {
    if (thresholds[threshold] === undefined) {
        return false;
    }
    if (limit === undefined) {
        return thresholds[threshold];
    }
    thresholds[threshold] = limit;
    if (threshold === 's') {
        thresholds["ss"] = limit - 1;
    }
    return true;
}
// export function humanize(withSuffix) {
//   if (!this.isValid()) {
//     return this.localeData().invalidDate();
//   }
//
//   const locale = this.localeData();
//   let output = relativeTime(this, !withSuffix, locale);
//
//   if (withSuffix) {
//     output = locale.pastFuture(+this, output);
//   }
//
//   return locale.postformat(output);
// }
//# sourceMappingURL=data:application/json;base64,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