import { hasOwnProp, isString } from '../utils/type-checks';
const aliases = {};
const _mapUnits = {
    date: 'day',
    hour: 'hours',
    minute: 'minutes',
    second: 'seconds',
    millisecond: 'milliseconds'
};
export function addUnitAlias(unit, shorthand) {
    const lowerCase = unit.toLowerCase();
    let _unit = unit;
    if (lowerCase in _mapUnits) {
        _unit = _mapUnits[lowerCase];
    }
    aliases[lowerCase] = aliases[`${lowerCase}s`] = aliases[shorthand] = _unit;
}
export function normalizeUnits(units) {
    return isString(units) ? aliases[units] || aliases[units.toLowerCase()] : undefined;
}
export function normalizeObjectUnits(inputObject) {
    const normalizedInput = {};
    let normalizedProp;
    let prop;
    for (prop in inputObject) {
        if (hasOwnProp(inputObject, prop)) {
            normalizedProp = normalizeUnits(prop);
            if (normalizedProp) {
                normalizedInput[normalizedProp] = inputObject[prop];
            }
        }
    }
    return normalizedInput;
}
//# sourceMappingURL=data:application/json;base64,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