@extends('layouts.app')

@section('title', $app_setting['name'] . ' | User List')

@section('content')
    <!-- ****Body-Section***** -->
    <div class="app-main-outer">
        <div class="app-main-inner">
            <div
                class="page-title-actions px-3 py-3 d-flex justify-content-between align-items-center bg-white rounded mb-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb m-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active" aria-current="page">User</li>
                    </ol>
                </nav>
                <div class="ms-auto">
                    <a href="{{ route('user.create') }}" class="btn btn-shadow btn-outline-primary mr-3 ms-auto">
                        {{ __('+ New Student / User') }}
                    </a>
                </div>
            </div>

            <div class="row" id="deleteTableItem">
                <div class="col-md-12">
                    <div class="card mb-5">
                        <div class="card-body">
                            <div class="table-responsive-lg">
                                <table id="dataTable" class="table">
                                    <thead>
                                        <tr>
                                            <th><strong>#</strong></th>
                                            <th><strong>ID</strong></th>
                                            <th><strong>User</strong></th>
                                            <th><strong>Email</strong></th>
                                            <th><strong>Phone</strong></th>
                                            <th><strong>Account Verified</strong></th>
                                            <th><strong>Status</strong></th>
                                            @if (Auth::user()->hasRole('admin'))
                                                <th><strong>Action</strong></th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($users as $user)
                                            <tr>
                                                <td class="tableId">{{ $loop->iteration }}</td>
                                                <td class="tableId">#{{ $user->id }}</td>
                                                <td class="tableProduct">
                                                    <div class="listproduct-section">
                                                        <div class="userImage">
                                                            <img src="{{ $user->profilePicturePath }}"
                                                                class="img-fluid w-100 h-100 object-fit-cover rounded-circle">
                                                        </div>
                                                        <div class="product-pera">
                                                            <p class="priceDis">{{ $user->name }}</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="tableId">{{ $user->email }}</td>
                                                <td class="tableId">{{ $user->phone }}</td>
                                                <td class="tableCustomar">
                                                    @if ($user->is_active)
                                                        <span class="badge rounded-pill text-bg-success">Yes</span>
                                                    @else
                                                        <span class="badge rounded-pill text-bg-danger">No</span>
                                                    @endif
                                                </td>
                                                <td class="tableStatus">
                                                    @if ($user->trashed())
                                                        <div class="statusItem">
                                                            <div class="circleDot animatedPending"></div>
                                                            <div class="statusText">
                                                                <span class="stutsPanding">Deleted</span>
                                                            </div>
                                                        </div>
                                                    @else
                                                        <div class="statusItem">
                                                            <div class="circleDot animatedCompleted"></div>
                                                            <div class="statusText">
                                                                <span class="stutsCompleted">Active</span>
                                                            </div>
                                                        </div>
                                                    @endif
                                                </td>
                                                @if (Auth::user()->hasRole('admin'))
                                                    <td class="tableAction">
                                                        <div class="action-icon">
                                                            @if ($user->trashed())
                                                                <a class="circleIcon" data-bs-toggle="tooltip"
                                                                    data-bs-placement="top"
                                                                    data-bs-custom-class="custom-tooltip"
                                                                    data-bs-title="Restore User"
                                                                    href="{{ route('user.restore', $user->id) }}">
                                                                    <img src="{{ asset('assets/images/icon/rotate-left.svg') }}"
                                                                        alt="icon">
                                                                </a>
                                                            @else
                                                                <a class="circleIcon" data-bs-toggle="tooltip"
                                                                    data-bs-placement="top"
                                                                    data-bs-custom-class="custom-tooltip"
                                                                    data-bs-title="Edit User"
                                                                    href="{{ route('user.edit', $user->id) }}">
                                                                    <img src="{{ asset('assets/images/icon/edit.svg') }}"
                                                                        alt="icon">
                                                                </a>
                                                                <a class="circleIcon" data-bs-toggle="tooltip"
                                                                    data-bs-placement="top"
                                                                    data-bs-custom-class="custom-tooltip"
                                                                    data-bs-title="Delete User" href="#"
                                                                    onclick="deleteAction('{{ route('user.destroy', $user->id) }}')">
                                                                    <img src="{{ asset('assets/images/icon/trash.svg') }}"
                                                                        alt="icon">
                                                                </a>
                                                                @if (!$user->instructor && !$user->is_admin)
                                                                    <a class="circleIcon" data-bs-toggle="tooltip"
                                                                        data-bs-placement="top"
                                                                        data-bs-custom-class="custom-tooltip"
                                                                        data-bs-title="Promote to Instructor"
                                                                        href="{{ route('instructor.promote', $user->id) }}">
                                                                        <i
                                                                            class="bi bi-person-fill-up circleIcon text-dark"></i>
                                                                    </a>
                                                                @endif
                                                            @endif
                                                        </div>
                                                    </td>
                                                @endif
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- ****End-Body-Section**** -->
    </div>
@endsection
